#include "basic_io.h"
#include "DM9000A.h"
#include <alt_types.h>
#include "alt_up_ps2_port.h"
#include "ps2_keyboard.h"
#include "math.h"
#include "terrain.h"
#include "sprites.h"
#include "gameLogic.h"
#include "network.h"
#include "keyboard.h"
#include "rxInterrupt.h"

#define msleep(msec)    usleep(1000*msec);

//the HW has only 4 addresses to write to
//#define IOWR_VGA_DATA(base,offset,data) IOWR_32DIRECT(base,offset*4,data)
//#define IORD_VGA_DATA(base,offset) IORD_32DIRECT(base,offset*4)
//#define BLUE_ARROW 11
//#define RED_ARROW 21
//#define BLUE_RETICLE 12
//#define RED_RETICLE 22

unsigned int receive_buffer_length;
unsigned char receive_buffer[1600];
//float terrain[GAMEBOARD_LENGTH+1];


 // Syncs the terrain between master and slave systems.


void syncTerrain(int *terrainNet, struct spriteStruct * worms ){
        /*int terrainCounter = GAMEBOARD_LENGTH/2;
        int i;
        for (i=0; i<terrainCounter; i++){
            terrainNet[i] = (int)terrain[i];
        }
        send_terrain(terrainNet, NULL, 0, terrainCounter, TERRAIN_REDRAW_1);                               
        while(second_packet_ready == 0){
        }
        for (i=0; i<terrainCounter; i++){
            terrainNet[i] = (int)terrain[terrainCounter+1+i];
        }
        send_terrain(terrainNet, worms, 0, terrainCounter, TERRAIN_REDRAW_2);   */         
}

void playSound(){
    int waitingTime = 50;
    
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x000C);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x000B);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x000A);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0009);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0008);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0007);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0006);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0005);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0004);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0003);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0002);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 2, 0x0001);
    msleep(waitingTime);
    IOWR_16DIRECT(AUDIO_BASE, 0, 0x0000); 
}

int main(){
    
int i;
//int terrainNet[GAMEBOARD_LENGTH+1];
int singlePlayer = 1;
int CH = 0,CV=0,CC=1;

alt_u8 key = 0;

// Initalize the DM9000 and the Ethernet interrupt handler
//initializeEthernet();
  
intitialize_keyboard();
printf("Ready to send messages\n");


// Animation (frame) constants
int animCount = 0;
int breath[4] = {13, 15, 17, 19};
int arrowBounce = 30;
int walk = 0;
int swing = 0;
int projAnim = 0;
int powAnim = 0;

// Game State Constants
int nextGame = 0;
int wormHealth[4] = {100, 100, 100, 100};
int wormsTurn = 0;        // Indicates which worms turn it is (0-3)
int distance = 0;
int walkCount = MAX_STEPS;
int hitWorm = 0;
int pause = 0;
float angle[4] = {0, 0, 0, 0};
float power[4] = {0, 0, 0, 0};
float vx = 0;
float vy = 0;
int collisionPos = 0;
int weapon[4] = {0,0,0,0};

enum GAMESTATE 
{
    STANDING, 
    WALKING_LEFT, 
    WALKING_RIGHT, 
    ANGLE_UP, 
    ANGLE_DOWN, 
    POWER_UP, 
    POWER_DOWN,
    CHANGE_WEAPON, 
    BAZOOKA_PROJECTILE,
    SWING_BAT,
    BAT_PROJECTILE,
    POW,
    PAUSE
};
enum GAMESTATE state;

while(1)
{
// Initialize the terrain    
genTerrain(terrain); 
drawTerrain(terrain, GAMEBOARD_LENGTH, 0);
initializeWorms(s, terrain);


// Initialize the game variables
nextGame = 0;
wormsTurn = 0;
state = STANDING;
for(i = 0; i < 4; i++) {wormHealth[i] = 100; angle[i] = 0;}

  
while((nextGame == 0))
{
    if ((animCount % 50) == 0){
        placeArrows(s, wormsTurn, wormHealth, &arrowBounce); 
        
        if (wormsTurn % 2 == getMaster() || singlePlayer == 1) {
            key = getKey(); 
            switch(key)
            {
                case LEFT_ARROW:
                    state = WALKING_LEFT; 
                    walk = 0;
                     //send_message(LEFT_ARROW_NET);
                break;  
         
                case RIGHT_ARROW:
                    state = WALKING_RIGHT;
                    walk = 0;
                    //send_message(RIGHT_ARROW_NET);
                break;
         
                case UP_ARROW:
                    state = ANGLE_UP;
                    //send_message(UP_ARROW_NET);
                break;
         
                case DOWN_ARROW:
                    state = ANGLE_DOWN; 
                    //send_message(DOWN_ARROW_NET);
                break;
         
                case PAGE_UP:
                    state = POWER_UP;
                break;
         
                case PAGE_DOWN:
                    state = POWER_DOWN;
                break;
        
                case END:
                    state = CHANGE_WEAPON;
                break;
        
                case SPACEBAR:
                    if(weapon[wormsTurn] == BAZOOKA) {state = BAZOOKA_PROJECTILE;}
                    else if(weapon[wormsTurn] == BAT) {swing = 0; state = SWING_BAT;}
                    playSound();
                    CC=1;
                    //send_message(SPACEBAR_NET);
                break;  
                
                case DEL:                                    
                   //syncTerrain(terrainNet, s);        
                break;
                
                case F1:
                    CH+=10;
                    centerScreen(s[wormsTurn].h+CH, s[wormsTurn].v+CV);
                break;
                
                case F2:
                    CH-=10;
                    centerScreen(s[wormsTurn].h+CH, s[wormsTurn].v+CV);
                break;
                
                case F3:
                    CV+=10;
                    centerScreen(s[wormsTurn].h+CH, s[wormsTurn].v+CV);
                break;
                
                case F4:
                    CV-=10;
                    centerScreen(s[wormsTurn].h+CH, s[wormsTurn].v+CV);
                break;
            } 
        } /*else {
            // key = getRemoteKey();
                
            switch(key)
            {
                case LEFT_ARROW_NET:PAUSE
                    state = WALKING_LEFT; 
                    walk = 0;
                break;  
         
                case RIGHT_ARROW_NET:
                    state = WALKING_RIGHT;
                    walk = 0;
                break;
         
                case UP_ARROW_NET:
                    state = ANGLE_UP;
                break;
         
                case DOWN_ARROW_NET:
                    state = ANGLE_DOWN; 
                break;
                 case SPACEBAR_NET:
                    if(weapon[wormsTurn] == BAZOOKA) {state = BAZOOKA_PROJECTILE;}
                    else if(weapon[wormsTurn] == BAT) {swing = 0; state = SWING_BAT;}
                break;  
            }
        }*/

        key = 0x00;
     }

    switch(state)
    {    
        case STANDING:
            if((animCount % 50) == 0){
                s[9].shown = 0; // do not show the projectile
                placeReticle(s, wormsTurn, angle[wormsTurn], 5*power[wormsTurn] + RETICLE_OFFSET);
                animBreath(s, breath);
                sitWorms(s, terrain);
                drawWeapon(s, wormsTurn, angle[wormsTurn], weapon[wormsTurn]);
                if(CC==1){
                    centerScreen(s[wormsTurn].h, s[wormsTurn].v);
                    CC=0;
                }        
            }
        break;
    
    case WALKING_LEFT:
        if((animCount % 40) == 0){
            s[9].shown = 0; // do not show the projectile    
            s[8].shown = 0; // do not display reticle 
    
            if(s[wormsTurn].flip == LEFT)
            { 
                if(walkCount > 0)
                {    
                    if(walk == 7) {walk = 0; walkCount--;}  
                    animWalk(s, terrain, wormsTurn, &walk);
                    if(walk == 7) {walkCount--; state = STANDING;}  
                }    
                else {state = STANDING;}
            }
    
            else{s[wormsTurn].flip = LEFT; state = STANDING;}    
            centerScreen(s[wormsTurn].h, s[wormsTurn].v);
        }
   break;
    
    case WALKING_RIGHT:
        if((animCount % 40) == 0)
        {
            s[9].shown = 0; // do not show the projectile    
            s[8].shown = 0; // do not display reticle     
            if(s[wormsTurn].flip == RIGHT)
            { 
                if(walkCount > 0)
                {
                    if(walk == 7) {walk = 0; walkCount--;}  
                    animWalk(s, terrain, wormsTurn, &walk);
                    if(walk == 7) {walkCount--; state = STANDING;}  
                }
                else {state = STANDING;}
            }
    
            else{s[wormsTurn].flip = RIGHT; state = STANDING;}   
            centerScreen(s[wormsTurn].h, s[wormsTurn].v);
        }
    break;
    
    case ANGLE_UP:
        if(angle[wormsTurn] > -90) {angle[wormsTurn] -= ANGLE_INC;}
        state = STANDING;
    break;
    

    case ANGLE_DOWN:
        if(angle[wormsTurn] < 90) {angle[wormsTurn] += ANGLE_INC;}
        state = STANDING;
    break;
    
    case POWER_UP:
        power[wormsTurn] += 1;
        state = STANDING;
    break;
    
    case POWER_DOWN:
        if(power[wormsTurn] > 0) {power[wormsTurn] -= 1;}
        state = STANDING;
    break;
    
    case CHANGE_WEAPON:
        if(weapon[wormsTurn] == BAZOOKA) {weapon[wormsTurn] = BAT;}
        else if(weapon[wormsTurn] == BAT) {weapon[wormsTurn] = BAZOOKA;}
        state = STANDING;
    break;
    
    case BAZOOKA_PROJECTILE:
        if ((animCount % 40) == 0)
        {
            collisionPos = animProjectile(s,terrain, wormsTurn, &projAnim, angle[wormsTurn], power[wormsTurn], &vx, &vy); 

            if(collisionPos >= 0)
            {
                drawDamage(terrain, collisionPos);
                smoothTerrain(terrain,1);
                drawTerrain(terrain, GAMEBOARD_LENGTH, 0);
                projAnim = 0;
   
                for(i = 0; i < 4; i++) 
                {
                    distance = collisionPos - s[i].h;
                    if (distance < 0) {distance = -distance;}
                    if ( distance < DAMAGE_RADIUS ) {wormHealth[i] -= DAMAGE_RADIUS - distance + 10;}
                    if ( distance < BULLSEYE) {wormHealth[i] -= 15;}
                    if ( wormHealth[i] <= 0 ) {s[i].shown = 0;}
                }
    
                nextGame = selectNextWorm(&wormsTurn, wormHealth);
                walkCount = MAX_STEPS;
                state = POW;
            }
        }   
        centerScreen(s[9].h, s[9].v);
    break;
    
    case SWING_BAT:
        if((animCount % 10) == 0)
        {
            animSwing(s, wormsTurn, &swing);
            if(swing == 5) {hitWorm = findHitWorm(s, wormsTurn); state = BAT_PROJECTILE;}
        }
    break;
    
    case BAT_PROJECTILE:
        if(hitWorm == wormsTurn)
        {
            nextGame = selectNextWorm(&wormsTurn, wormHealth);
            state = STANDING;   
        }
        else // a worm has been hit
        {
            if ((animCount % 40) == 0)
            {
                collisionPos = animFlyingWorm(s,terrain, hitWorm, wormsTurn, &projAnim, angle[wormsTurn], power[wormsTurn], &vx, &vy); 
                if(collisionPos >= 0)
                {
                    projAnim = 0; 
                    wormHealth[hitWorm] -= 25;
                    if ( wormHealth[hitWorm] <= 0 ) {s[hitWorm].shown = 0;}
                    nextGame = selectNextWorm(&wormsTurn, wormHealth);
                    walkCount = MAX_STEPS;
                    state = POW;
                }
            }
            centerScreen(s[hitWorm].h, s[hitWorm].v);  
        }  
    break;     
    
    case POW:
        if((animCount % 10) == 0)
        {
            s[9].shown = 0;
            drawPOW(s, hitWorm, &powAnim);
        }
        if(powAnim == 60) 
        {
            //sound = 0;
            powAnim = 0; 
            s[10].shown = 0;
            state = PAUSE;
        }
        /*if(powAnim == 0 && sound==0){
            sound = 1;
            playSound();
        }*/
        break;
        
    case PAUSE:
        pause = 80000;
        while(pause) {pause--;}
        state = STANDING;
        break;
         
    } // end switch    
    animCount++;
    updateSprites(s);

// Pause
    int count = 80;
    while(count) {count--;};  
   }// End gamemode while
} // End infinite loop while
 
 return 0;
}
    	



